#ifdef COMMENTS

/*
   Menu file structures for OPUS-CBCS 1.10 None of this material is obvious
   by itself.  It isn't for novices or the weak hearted.  Refer to the menu
   system's technical reference material before throwing up your hands
   because after reading that stuff, you'll really have a good reason to get
   upset.

   (Assumes LEGIBLE.H has been included.)
*/
/*
             MENU FILE LAYOUT

      Ŀ
           Menu File Header          |F
      ĳ    |I
       * Menu Version                |L
       * Total items                 |
          |H
                                       |E
      Ŀ    |A --.
              Menu Header            |D    \
      Ŀ   |R  ---\--- mLore+1 menu headers
              Menu Header           |       \
      Ŀ  |S   ---'
              Menu Header          |T
       ĳ  |R
        * 1st menu item's offset    |U
         * number of menu items      |C
          |T

      Ŀ      ---.
            Menu Group                   \
      Ŀ      ---\--- mLore+1 menu sets
             Menu Group                   \
             ---'
              Menu Group         
      ĳ
       * Item: Prv/Lok/*Txt/Type 
        * Item: Prv/Lok/*Txt/Type 
        * Item: Prv/Lok/*Txt/Type 
         * Item: Prv/Lok/*Txt/Type 
        
*/
#endif


enum  _MENUTYPE {
         mMAIN,
         mCONFIG,
         mSYSOP,
         mMESSAGE,
         mFILE,
         mHISTORY,
         mOPED,
         mLORE,
         mSECTION,
         mCUSTOM1,
         mCUSTOM2,
         mCUSTOM3,
         mCUSTOM4,
         mCUSTOM5,
         mCUSTOM6
      };

#define  NUMBER_OF_MENUS   (mCUSTOM6+1)
#define  M_VERSION         6


struct _MENU_Hdr
{
   word FirstItemOffset;
   word NumberOfItems;
   word DisplayOffset;
};

#define  mHDR  (struct _MENU_Hdr)


struct _MENU_Item
{
      byte  MinimumPriv;         /* Menu item's minimum privilege ........ */
      byte  M_filler;	      	 /* Fill to word-align structure ..........*/
      long  PrivMask;            /* Menu item's LOCK mask ................ */
      word  DisplayOffset;       /* Menu item's displayed title .......... */
      word  MenuItemType;        /* Menu item's Opus Function Code ....... */
      word  ItemMiscinfo;        /* Menu item's EXEC Command or OEC Path.. */
};

struct _MENU_FileHeader
{
      word              MenuVersion;
      word              ItemCount;
      struct _MENU_Hdr  Menus[NUMBER_OF_MENUS];
/*      struct _MENU_Hdr  Menus[NUMBER_OF_MENUS]; */
};



#define MENU_DIGIT           0x0050
#define MENU_CR              0x0051

#define _GOODBYE             0x1001 /* G */
#define _STATS               0x1002
#define _SHOW                0x1003
#define _YELL                0x1004
#define _USERLIST            0x1005
#define _VERSION             0x1006
#define _OUTSIDE             0x1007
#define _SYSOP_Message       0x1009 

#define CHG_AREA             0x1008 /* A */

#define _MAIN_mode           0x10f1 /* Q */
#define _CONFIG_mode         0x10f2 /* C */
#define _HISTORY_mode        0x10fa /* H */
#define _SYSOP_mode          0x10f3
#define _MESSAGE_mode        0x10f4 /* M */
#define _FILE_mode           0x10f5 /* F */
#define internal_oped        0x10f8
#define internal_lore        0x10f9


#define _SECTION_mode         0x1100 		/* Chose sections. */

#define _CUSTOM1_mode            0x1101		/* CUSTOM menu 1 */
#define _CUSTOM2_mode            0x1102		/* CUSTOM menu 2 */
#define _CUSTOM3_mode            0x1103		/* CUSTOM menu 3 */
#define _CUSTOM4_mode            0x1104		/* CUSTOM menu 4 */
#define _CUSTOM5_mode            0x1105		/* CUSTOM menu 5 */
#define _CUSTOM6_mode            0x1106		/* CUSTOM menu 6 */



/* #define SET_PWD              0x2001 */
#define SET_HELP             0x2002
#define SET_NULLS            0x2003
#define SET_WIDTH            0x2004
#define SET_LEN              0x2005
#define SET_TABS             0x2006
#define SET_MORE             0x2007
#define SET_VID              0x2008
#define SET_CLS              0x2009
#define SET_EDIT             0x200a
#define SET_IBM              0x200b
/* Added for Opus 1.20 */
#define SET_DEF              0x200c		/* Set default protocol */
#define SET_TALK             0x200f /* Configure for blind user */
#define SET_MENU             0x2010 /* Return to last menu */
#define SET_ASKGRAPH         0x2011 /* Ask for graphics every call */
#define SET_KEYS             0x2012 /* User wants hotkeys at all help levels*/
#define SET_GMENUS           0x2013 /* User wants long graphic menus */
#define SET_BLOCK            0x2014 /* User doesn't want to talk to others */
#define SET_TIME             0x2015 /* User wants to see time remaining    */

#define USR_PWD              0x2050
#define USR_ADDRESS          0x2051		/* Change Address */
#define USR_PHONE            0x2052		/* Change phone number */
#define USR_CITY             0x2053
#define USR_LIST             0x2054 /* User List Options */
#define USR_LANG             0x2055 /* User Language Option */
#define USR_ALIAS            0x2056		/* Allow user to change alias */
#define USR_BIRTHDAY         0x2057		/* Allow user to change birthday */
#define USR_ANSWER           0x2058		/* Allow user to change answers */
#define USR_NAME             0x2059		/* Allow user to change answers */


#define MSG_FORWARD          0x3001 /* N */
#define MSG_PRIOR            0x3002 /* P */
#define MSG_PARENT           0x3003
#define MSG_CHILD            0x3004
#define MSG_NEXT             0x3005
#define MSG_NONSTOP          0x3006 /* = */
#define MSG_EDIT_NEW         0x3007 /* E */
#define MSG_EDIT_REPLY       0x3008 /* R */
#define MSG_UPLD             0x3009
#define MSG_LAST             0x300a /* Re-Read CURRENT MESSAGE */
#define MSG_LIST             0x300b
#define MSG_SCAN             0x300c
#define MSG_INQ              0x300d
#define MSG_KILL             0x300e
#define MSG_HURL             0x300f
#define MSG_FRWD             0x3010
#define MSG_BOMB             0x3011
#define MSG_XPRT             0x3012
#define MSG_QUICK            0x3013
#define MSG_QINQ             0x3014
#define MSG_RULES            0x3015		/* Show RULES.BBS to user */
#define MSG_NAREA            0x3016		/* Skips to next area with unread msg */
#define MSG_HELP             0x3017		/* Shows help if its in sysmsg.dat */

#define SYS_AREA             0x4001
#define SYS_MAIL             0x4002
#define SYS_EVNT             0x4003
#define SYS_PRIV             0x4004

#define F_LOCATE             0x5001
#define F_TITLES             0x5002 /* X */
#define F_DSPL               0x5003
#define F_DNLD               0x5004 /* D */
#define F_UPLD               0x5005 /* U */
#define F_RAWDIR             0x5006
#define F_ARCDIR             0x5007
#define F_HURL               0x5008
#define F_KILL               0x5009
#define F_DNHANG             0x500A		/* Download and hangup */
#define F_NEW                0x500B		/* Show new files in all areas */
#define F_HELP               0x500C		/* Shows help if its in sysfile.dat */
#define F_TEMP               0x500D		/* Use a different path for up/dl */
#define F_LONG               0x500E		/* Long descriptions instead of short */
#define F_ADOPT             0x500F		/* Read in orphan files              */

#define ED_SAVE              0x6001
#define ED_ABORT             0x6002
#define ED_LIST              0x6003
#define ED_CHG               0x6004
#define ED_INSRT             0x6005
#define ED_DEL               0x6006
#define ED_CONT              0x6007
#define ED_TO                0x6008
#define ED_FROM              0x6009
#define ED_SUBJ              0x600a
#define ED_ATTR              0x600b
#define ED_DISK              0x600c
#define ED_UUCP              0x600d

#define _PICK_section        0x7000 		/* Section choice(s) */
#define _MAKE_section        0x7001 		/* Section choice(s) */
#define _MY_section          0x7002 		/* Section choice(s) */

#define _Send_message        0x7050		/* Send a chat message */
#define _See_lines           0x7060		/* See who else is online            */
#define _See_chat            0x7061		/* Check for chat messages           */

#define _MY_Macro            0x8000		/* Execute a user macro */
#define _MAKE_Macro          0x8001		/* User sets macro                   */
#define _MAKE_Msg_Macro      0x8002		/* User sets macro                   */
#define _MAKE_File_Macro     0x8003		/* User sets macro                   */

#define _STACK                 0x8050		/* Stack up menu selection */

/*--------------------------------------------------------------------------*/
/* Menu subsystem routines                                                  */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* Menu subsystem data                                                      */
/*--------------------------------------------------------------------------*/
extern struct _MENU_FileHeader *MENU_Root;
extern word                     MENU_Mode;


