include mc.ash
.MODEL SMALL
;
;gtod3(item);
;
;Returns one of the time or date components
;from MSDOS: Item:
;
;0	Year 80 - 99
;1	Month 0 - 11
;2	Day 0 - 30
;3	Day of week 0 - 6
;4	Hour 0 - 23
;5	Minute 0 - 59
;6	Second 0 - 59
;7	Hundredth 0 - 99
;
.CODE
;
;Return one of the time or date components.
;Returns -1 if bad arg.
;
func _gtod3
	mov	bx,arg0		;get the arg,
	mov	ax,-1		;check in range
	cmp	bx,7
	ja	g2
	add	bx,bx
	call	word ptr cs:jmptbl[bx]
g2:
endf _gtod3
;
;Table of our functions.
;
jmptbl label word
	dw	year
	dw	month
	dw	day
	dw	daywk
	dw	hour
	dw	min
	dw	sec
	dw	hund
page
;
;These are the calls to MSDOS to get the right
;thing, and to put in AX, and do any 
;compensation for 1 - N to 0 - N.
;
year:	mov	ah,2ah
	int	21h
	mov	ax,cx
	ret

month:	mov	ah,2ah
	int	21h
	mov	al,dh
	mov	ah,0
	dec	ax
	ret

day:	mov	ah,2ah
	int	21h
	mov	al,dl
	mov	ah,0
	dec	ax
	ret

daywk:	mov	ah,2ah
	int	21h
	mov	ah,0
	ret

hour:	mov	ah,2ch
	int	21h
	mov	ah,0
	mov	al,ch
	ret

min:	mov	ah,2ch
	int	21h
	mov	ah,0
	mov	al,cl
	ret

sec:	mov	ah,2ch
	int	21h
	mov	ah,0
	mov	al,dh
	ret

hund:	mov	ah,2ch
	int	21h
	mov	ah,0
	mov	al,dl
	ret

	end
