/* 
;;
;;int getstring(string)	Input a line of text, usual editing. Returns
;;char string[81];	string length. Maximum string length is 80 chars.
;;			CR, LF, ESC terminates input, ^X, ^C, ^U deletes
;;			the entire line, ^D, ^G, ^H, DEL delete one character.
;;			^R restores the line. NOTE: The string must be init-
;;			ialized with a null before the first call; the previous
;;			string can be recovered by ^R. Beeps on unsupported 
;;			control chars or line too long. Calls only lconin(),
;;			lconout().
;;
*/
/* Get an input string; return NULL if error or empty line. Provide the
usual minimum editing capabilities.  */

getstring(string)
char string[];
{
int count;
char c;
char *p;
int pi;
	count= 0;

	while (1) {

		c= lconin();			/* get a character, */
		switch (c) {
		case 0x0d:			/* process it, */
		case 0x0a:
		case 0x1b:
			string[count]= '\0';	/* terminate string, */
			return(count);		/* return string length */
			break;

		case 0x08:
		case 0x7f:			/* delete character */
		case 0x13:
			if (count) {
				--count;	/* one less char, */
				lconout('\010');
				lconout(' ');
				lconout('\010');
			}
			break;
			case 0x18:
		case 0x15:			/* delete line */
		case 0x19:
		case 0x03:
			while (count) {
				--count;
				lconout('\010');
				lconout(' ');
				lconout('\010');
			}
			break;
		case 0x04:			/* retype character, */
			if (string[count])
				lconout(string[count++]);
			break;
		case 0x12:			/* retype line, */
			while (string[count]) {
				lconout(string[count++]);
			}
			break;

		default:			/* insert character */
			if ( (c > 0x1f) && (c < 0x7f) && (count < 80) ) {
				string[count++] =c;
				string[count]= '\0';
				lconout(c);
			} else
				lconout(0x07);
			break;
		}
	}
}
