#include <fileinfo.h>

/*

getinfo(filename,n,fileinfo)
		Returns specific information on the requested filename.
		This also is used for search first/next to locate a 
		series of matching files, using the usual wildcards
		* and ?. The function returns 0 when no matching file
		is found.

		filename is a string specifying the file; it is fully
		qualified, ie. it has drive letter/pathname info in it.
		It may be in either upper or lower case.

		N is an integer that indicates which pass # this is. N is 0
		for the first time, and increments for each subsequent
		call.

		fileinfo is the structure defined in puppy.h that the 
		information is returned in. Its generic enough that it
		should be easy enough to fill in for most DOSs, or the
		information left zeroed. The contents of the structure
		is preserved between calls; it can be used to store stuff
		between iterations. n == 0 should be used to set the info
		for later calls. (The MSDOS version uses the _find()
		function defined in MS-ASM.ASM, which stores its info
		in added space in the fileinfo structure.)


		Unlike search first/next in CP/M, there may be any number
		of file system calls made in between calls to getinfo().
		If this is a problem (CP/M ...) then getinfo() should make
		a list of files when n == 0 and return them one by one
		in each call.

		It is even possible to merely get basic file info when
		n == 0, and return 0 for all other calls; the only effect
		will be that wildcards cant be used in various places.

*/

/* Get file info. */

getinfo(name,n,fileinfo)
char *name;			/* filename, */
int n;				/* interation counter */
struct _fileinfo *fileinfo;	/* returned file information */
{
	fileinfo-> xfbuf.s_attrib= 0;		/* set search attribute */
	if (!_find(name,n,&fileinfo-> xfbuf))	/* do the MSDOS thing, */
		return(0);			/* no matches */

	strcpy(fileinfo-> name,fileinfo-> xfbuf.name);
	fileinfo-> size= fileinfo-> xfbuf.fsize; /* copy in the basic info */

	fileinfo-> time.day= fileinfo-> xfbuf.date & 0x0f;
	fileinfo-> time.month= (fileinfo-> xfbuf.date >> 5) & 0x0f;
	fileinfo-> time.year= ((fileinfo-> xfbuf.date >> 9) & 0x3f) + 80;

/* Unpack the MSDOS time. MSDOS keeps file time seconds in 2 sec. 
resolution. Who needs it anyways. */

	fileinfo-> time.hour= fileinfo-> xfbuf.time >> 11;
	fileinfo-> time.minute= (fileinfo-> xfbuf.time >> 5) & 0x3f;
	fileinfo-> time.second= 0;

	return(1);
}

