/*
 *  s p a c k
 *
 *  Send a Packet for Fido
 */

extern int pad;			/* number of pad characters */
extern char padchar;		/* the pad character */
extern char eol;		/* end of line character */

extern int parflg;		/* Ptel parity type */

#define SOH 1
#define tochar(ch)  ((ch) + ' ')
#define unchar(ch)  ((ch) - ' ')
#define ctl(ch)     ((ch) ^ 64 )
#define unpar(ch)   ((ch) & 127)


spack(type,num,len,data)
char type, *data;
int num, len;
{
int i;					/* Character loop counter */
char chksum;

  
	if (chkabort()) return('A');

	for (i= 0; i < pad; i++) 
		modout(padchar); 	/* Issue any padding */

	modout(SOH);			/* packet marker */
	modout(tochar(len + 3));	/* character count */
	modout(tochar(num));		/* packet number */
	modout(type);			/* packet type */

	chksum= tochar(len + 3) + tochar(num) + type;

	for (i= 0; i < len; i++) {	/* send the data */
		modout(data[i]);
		chksum += data[i];	/* checksum it */
	}

	chksum = (((chksum & 0300) >> 6) + chksum) & 077; /* Compute final checksum */

	flush(0);			/* flush the line before last byte ... */
	modout(tochar(chksum));		/* send the checksum, */
	modout(eol);			/* send end of line */
}
