#include "fido.h"
#include "fidomem.h"
#include "proto.h"

/* The questionaire module. 

Questions are just lines of text, where the first character is a marker that
indicates what to do with the line:

	/	Get a line of text from the caller.
	+N	Multiple choice, 1 - N choices,
	?	Conditional question: if the last multiple choice
		answer was the last choice ("other") then
		get a line of text. Merely to allow A, B, C, other
		type questions.
	!	Conditional statement, operates the same as ?.
		If executed, it terminates the questionaire. Lets
		you ask if they want to fill it out or not.
	*	Put callers name and signon date in answer file.
	_	Clear all conditional flags.

		Any other character indicates a prompt or
		other plain text.

* Enter callers data,				recd header
Do you want to fill in a questionaire:		ask if continue,
+2 (1) Yes (2) No				get answer,
!						terminate if last ans.
/Describe your system. (One line)		text question
What comm program are you using:		plain text
+3(1)MINITEL (2)PC-TALK (3)Other:		multiple choice
?What is the name of your comm program? 	asked if answer above was 3
Thank you					plain text

 */

question(infile,outfile)
char *infile,*outfile;
{
int q;
int a;
char c;
char *ques,buf[SS],ans[SS],date[20];
int i,num,other;

	q=opentf(infile,0);			/* open q. in language or BBS path */
	if (q == -1) return(0);			/* skip it if not exist, */

	a= open(outfile,2);			/* open answer file, */
	if (a == -1) a= creat(outfile,2);	/* if not there, make a new one */
	if (a == -1) {				/* if cant, then */
		close(q);			/* close up and return, */
		return(0);
	}
	lseek(a,0L,2);				/* seek to EOF on open file, */

	num= 0;
	while (rline(q,buf,sizeof(buf))) {	/* process each question, */
		ques= buf;			/* 1st char of line, */
		if (*ques == '*') {		/* * means put in caller info */
			gtod(date);
			sprintf(buf,0,"* %s %s\r\n",caller.name,date);
			write(a,buf,strlen(buf));

		} else if (*ques == '+') {	/* + means multiple choice, */
			++num;			/* bump question number, */
			++ques;			/* skip marker character, */
			i= atoi(ques);		/* maximum choice, */
			if (i == 0) i= 1;	/* (if bad questionaire) */
			++ques;			/* skip number, */
			do {			/* get a number 1 to N */
				getfield(ans,ques,1,1,sizeof(ans),1);
			} while ((atoi(ans) < 1) || (atoi(ans) > i));
			other= 0;		/* for conditional questions */
			if (atoi(ans) == i) other= 1;

			sprintf(buf,0,"%4u: %s\r\n",num,ans);
			write(a,buf,strlen(buf));

		} else if (*ques == '/') {	/* text answer, */
			++num;
			++ques;			/* skip marker, */
			mputs(ques);		/* printf the text following the / */
			getstring(ans);		/* get a line, */
			mcrlf();

			sprintf(buf,0,"%4u: ",num);
			write(a,buf,strlen(buf));
			write(a,ans,strlen(ans));
			write(a,"\r\n",2);

		} else if (*ques == '!') {
			if (other) break;	/* terminate if other */

		} else if (*ques == '?') {	/* conditional question */
			if (other) {		/* only if "other" selected */
				++ques;
				getfield(ans,ques,0,99,sizeof(ans),1);
				sprintf(buf,0,"?%3u: %s\r\n",num,ans);
				write(a,buf,strlen(buf));
			}
			other= 0;

		} else if (*ques == '_') {	/* clear flags, */
			other= 0;

		} else {			/* else just text, */
			mprintf(0,"%s\377",ques);
		}
	}
	line= 0;
	close(q);
	close(a);
	return(1);
}
