#include "fido.h"
#include "fidomem.h"
#include "proto.h"

/* Settle all debts in the caller record, and repair the last read message
for the FidoNet area, if found. */

void markusr() {
int i;
int f;				/* caller file */
struct _clr caller;		/* caller struct */
FLAG do_write;			/* 1 == caller struct needs writing */
long o;				/* caller record offset */

	cprintf(SM+27);

	f= open("caller.sys",2);
	if (f == -1) {				/* cant find it! */
		clprintf(SM+28);		/* "file not found" */
		return;
	}

	o= 0L;
	while (read(f,&caller,sizeof(struct _clr)) == sizeof(struct _clr)) {
		do_write= 0;
		for (i= 0; i < MAXLREAD; i++) {
			if (caller.lastmsg[i].area == fido.netmarea) {
				if (caller.lastmsg[i].msg > *msg_highest()) {
					caller.lastmsg[i].msg= *msg_highest();
					do_write= 1;
				}
				break;
			}
		}
		if (caller.debit || caller.credit) {
			if (caller.debit) {
				clprintf(0,"   %-20s: %s (%s)\r\n",
				    caller.name,bucks_str(caller.credit),bucks_str(caller.debit));
			}

			if ((caller.debit > 0) && (caller.credit >= caller.debit)) {
				caller.credit-= caller.debit;
				caller.debit= 0;
				do_write= 1;
			}
		}
		if (do_write) {
			lseek(f,o,0);
			write(f,&caller,sizeof(struct _clr));
		}
		o += sizeof(struct _clr);
	}
	close(f);
}
