#include "fido.h"
#include <ascii.h>
#include "fidomem.h"
#include "proto.h"

/*
	Some main section commands

change()	caller command: allows displaying and setting various caller record
		variables.

callers()	caller command: list callers in the caller list.

switches()	caller command: list and change event switches

*/

/* Change the caller record. */

void change() {
char name[SS],buff[SS],work[SS],*cp;
char sum;
int n,i,f;
struct _clr clr;
int seq;
long o,bit;

	while (1) {
		if (! isargs()) {
			mprintf(CM+90);

/*			if (caller.keys != KNONE) {		*/
/*				mprintf(CM+91);			*/	/* no trailing space */
/*				seq= 0;				*/	/* # of sequential keys */
/*				bit= 1L;			*/
/*				for (i= 0; i <= 32; i++) {	*/	/* note *33* loops, this */
/*					if (caller.keys & bit != 0L) {*/	/* makes n-31 get displayed */
/*						++seq;		*/	/* another in a row, */
/*						if (seq == 1) mprintf(0," %d",i + 1);	*/
/*						continue;	*/	/* next ... */

/*					} else {		*/	/* sequence broken */
/*						if (seq > 1) mprintf(0,"-%d", i);	*/
/*						seq= 0;		*/	/* reset it */
/*					}			*/
/*					bit <<= 1L;		*/	/* shift mask */
/*				}				*/
/*				mcrlf();			*/
/*			}					*/

			mprintf(CM+92,caller.name);			/* show raw name */
			mprintf(CM+93,caller.city);
			mprintf(CM+94,caller.pwd);
			 switch(uval(CLR_HLP,CLR_HLPS)) {
				case REGULAR: i= CM+97; break;
				case EXPERT: i= CM+98; break;
				case NOVICE: 
				default: i= CM+96; break;
			 }
			mprintf(CM+95); mprintf(i);

			mprintf(CM+100,uval(CLR_WID,CLR_WIDS));		/* cols */
			mprintf(CM+101,uval(CLR_LEN,CLR_LENS));		/* lines */
			mprintf(CM+104); mprintf(CM+0); mcrlf();	/* language */
			mprintf(CM+105,uval(CLR_NUL,CLR_NULS));		/* nulls */
		}

		switch (prompt(fido.cmd.chg,CM+25,"change.hlp",10)) {	/* 10 == M)ain-Menu */
		case 2:
			sprintf(buff,CM+107,caller.name); /* "New name [oldname]" */
			getfield(name,buff,0,99,sizeof(caller.name),0);
			if (! *name) break;		/* blank line */

			strproc(buff,name,99);		/* convert to fixed format */
			sum= strsum(buff);		/* new-name checksum */

			strproc(work,caller.name,99);	/* fix current name */
			if (same(buff,work)) {		/* if they match */
				strcpy(caller.name,name); /* (possible new capitalization, etc) */
				break; 
			}
/* 
	name =	Raw new caller name
	buff =	Fixed-format new name
	sum = 	Sum of fixed-format new name

Search through the caller base, and make sure this name isn't used yet. */

			mprintf(CM+108);		/* "wait..." */
			f= openclr();			/* open CALLER.SYS */
			if (f == -1) break;		/* eh? */

			i= 0; 				/* name not found yet, */
			while (read(f,&clr,sizeof(struct _clr)) == sizeof(struct _clr)) {
				if (sum == clr.sum) {	/* if sums match */
					strproc(work,clr.name,99); /* format it */
					if (same(buff,work)) {
						i= 1;	/* name already exists */
						break;
					}
				}
			}
			if (i) mprintf(CM+109);		/* "cant use that name" */
			else {				/* name is unique */
				if (fbit(FBIT_FNAME)) strcpy(caller.name,name);	/* install new name */
				else strcpy(caller.name,buff); /* fixed or free format */
				caller.sum= sum;	/* and name sum */
				write_clr();		/* write it out */
				mprintf(CM+110,caller.name);
				lprintf(LM+28,caller.name);
			}
			close(f);
			break;
		case 3: 				/* change address */
			sprintf(buff,CM+111,caller.city);
			getfield(work,buff,0,99,sizeof(caller.city),0); 
			if (! *work) break;
			if (extlogin(work)) {		/* check for external-login */
				mprintf(CM+112);
				break;			/* dont allow it */
			}
			strcpy(caller.city,work);	/* its OK */
			break;

		case 4: 				/* change password */
			sprintf(buff,CM+113,caller.pwd);
			getfield(work,buff,0,1,sizeof(caller.pwd),1); 
			if (*work) strcpy(caller.pwd,work);
			break;

		case 5:
			cp= getarg(CM+114,uval(CLR_HLP,CLR_HLPS) + 1);
			if (isdigit(*cp)) i= atoi(cp); else break;
			if ((i >= 1) && (i <= 3)) setuval(i-1,CLR_HLP,CLR_HLPS); 
			break;

		case 6:
			cp= getarg(CM+115,CLR_WID,uval(CLR_WID,CLR_WIDS));
			if (isdigit(*cp)) i= atoi(cp); else break;
			if ((i >= 16) && (i <= CLR_WID)) setuval(i,CLR_WID,CLR_WIDS);
			break;

		case 7:
			cp= getarg(CM+117,CLR_LEN,uval(CLR_LEN,CLR_LENS));
			if (isdigit(*cp)) i= atoi(cp); else break;
			if (i <= CLR_LEN) setuval(i,CLR_LEN,CLR_LENS);
			break;

		case 8: picklang(); break;

		case 9:
			cp= getarg(CM+119,CLR_NUL,uval(CLR_NUL,CLR_NULS));
			if (isdigit(*cp)) i= atoi(cp); else break;
			if (i <= CLR_NUL) setuval(i,CLR_NUL,CLR_NULS);
			break;

		case 10: return;
		}
	}
}

/* List all the callers on the system. */

void callers() {
int f;
struct _clr clr;
char pat[SS];

	makesname(pat,"caller.sys");
	f= open(pat,0);
	if (f == -1) return;

	if (uval(CLR_HLP,CLR_HLPS) < NORMAL) mprintf(CM+121);
	getfield(pat,string(CM+12),0,1,sizeof(pat),0);	/* "pattern to search for" */

	while (read(f,&clr,sizeof(struct _clr)) == sizeof(struct _clr)) {
		if (abort) break;
		if (!*pat || (strfnd(clr.name,pat) != -1)) {
			mprintf(0,"%-30s %s ",clr.name,clr.date);
			if ((uval(CLR_HLP,CLR_HLPS) == SYSOP) || !extlogin(clr.city)) 
				mputs(clr.city);
			mcrlf();
		}
	}
	close(f);
}

/* List and set event switches. */

void switches() {
int i,n,t;
FLAG no_events;
struct _sched *sc;
char *cp,buff[SS];

	while (1) {
		if (! isargs()) {
			mprintf(CM+122);
			for (i= 0; i < 8; i++) {
				mprintf(0,"%d=",i + 1);
				switch(istoggle(i)) {
					case 1:  mprintf(CM+1); break;
					case 0:  mprintf(CM+2); break;
					case -1: mprintf(CM+3); break;
				}
				mputs("   ");
			}
			mcrlf();
		}
		switch (prompt(fido.cmd.trigger,CM+258,"trigger.hlp",4)) { /* 4 == M)ain-Menu */
		case 3:						/* events */
			no_events= 1;				/* none found yet */
			for (i= 0; i < SCHEDS; i++) {
				if (abort) break;
				sc= &fido.sched[i];		/* keep it simple! */
				if (! sc-> tag) break;		/* NUL == end of table */
				if (sc-> tag == 'Y') continue;	/* only runnable */

				no_events= 0;
				n= til_event(i);		/* time til this event runs, */
				if (sc-> bits & SCHED_COMPLETE) mprintf(CM+123);
				else mprintf(CM+124,n);
				dsp_event(buff,i);		/* display it */
				mputs(buff);
			}
			if (no_events) mprintf(CM+125);
			mcrlf();
			break;

		case 2:						/* triggers */
			cp= getarg(CM+259);			/* "trigger #" */
			n= atoi(cp);
			if ((n < 1) || (n > 8)) break;

			i= -99;					/* nonsense and < 0 */
			cpyarg(buff,getarg(0,"%s, %s, %s: ",
			    string(CM+1),string(CM+2),string(CM+3)));
			stoupper(buff);
			if (same(buff,string(CM+1))) i= 1;	/* ON */
			if (same(buff,string(CM+3))) i= -1;	/* OFF */
			if (same(buff,string(CM+2))) i= 0;	/* ONCE */
			if (i != -99) stoggle(n - 1,i);		/* then set it */

/* Look for any events that have this trigger; reenable them. */

			if (i < 0) break;			/* only for ON/ONCE */
			for (i= 0; i < SCHEDS; i++) {
				if (!fido.sched[i].tag) break;	/* (no more defined) */
				if (fido.sched[i].swtch == n)	/* if right T)rigger */
					clrevt(i);		/* reenable it */
			}
			break;

		case 4: return;
		}
	}
}
