#ifndef _lint
static char *RCSid = "$Header$";
#endif

/*
   $Source$

		This file contains routines to implement a simple multiple
		alarm system.  The routines allow setting any number of alarms,
		and then checking if any one of them has expired.  It also allows
		adding time to an alarm.
*/


/*
 * $Log$
 */


#include "timer.h"

/*
	long timerset (t)
	unsigned int t;

	This routine returns a timer variable based on the MS-DOS
	time.  The variable returned is a long which corresponds to
	the MS-DOS time at which the timer will expire.  The variable
	need never be used once set, but to find if the timer has in
	fact expired, it will be necessary to call the timeup function.
	The expire time 't' is in hundredths of a second.
*/
long timerset (t)
unsigned int t;
{
	long l;
	int l2;
	int hours,mins,secs,ths;

	extern int week_day ();


	/* Get the DOS time and day of week */
	dostime (&hours,&mins,&secs,&ths);
	l2 = week_day ();

	/* Figure out the hundredths of a second so far this week */
	l =	l2	* PER_DAY	+
		hours	* PER_HOUR	+
		mins	* PER_MINUTE	+
		secs	* PER_SECOND	+
		ths			;

	/* Add in the timer value */
	l += t;

	/* Return the alarm off time */
	return (l);
	}

/*
	int timeup (t)
	long t;

	This routine returns a 1 if the passed timer variable corresponds
	to a timer which has expired, or 0 otherwise.
*/
int timeup (t)
long t;
{
	long l;

	/* Get current time in hundredths */
	l = timerset (0);

	/* If current is less then set by more than max int, then adjust */
	if (l < (t - 65536L))
		{
		l += PER_WEEK;
		}

	/* Return whether the current is greater than the timer variable */ 
	return ((l - t) >= 0L);
	}


/*
	long addtime (t1, t2)
	long t1;
	unsigned int t2;

	This routine adds t2 hundredths of a second to the timer variable
	in t1.  It returns a new timer variable.
*/
long addtime (t1, t2)
long t1;
unsigned int t2;
{
	return (t1 + t2);
	}
