/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*       (c) Copyright 1986, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*         The original sealink protocol is copyrighted by SEA, inc.        */
/*                                                                          */
/*                 This module was written by W.Wagner III                  */
/*        with modifications done by Bob Hartman and Vince Perriello        */
/*                                                                          */
/*                                                                          */
/*        BinkleyTerm "Main" Module: Terminal Emulation, HELP, and          */
/*                       File Transfer dispatching                          */
/*                                                                          */
/*                                                                          */
/*  This module is a very simple FOSSIL-based terminal emulator. It is      */
/*  provided for your information only.  You will find routines that need   */
/*  to be coded and identifiers to be resolved. It has been previously      */
/*  known as "OpusLink" and "OConnect". The use of the name "BinkleyTerm"   */
/*  does not preclude the possibility that another "OpusLink" or "OConnect" */
/*  could be released.                                                      */
/*                                                                          */
/*  There is absolutely no guarantee that anything here will work.  If you  */
/*  break this routine, you own both pieces.                                */
/*                                                                          */
/*  USAGE:  You may use this material in any program with no obligation     */
/*          as long as there is no charge for your program.  For more       */
/*          information about commercial use, contact the "OPUSinfo HERE"   */
/*          BBS (124/111).                                                  */
/*                                                                          */
/*                                                                          */
/*--------------------------------------------------------------------------*/


#include <stdio.h>
#include <signal.h>
#include <ctype.h>
#include <conio.h>
#include "com.h"
#include "xfer.h"

#define ALTX 0x2d00
#define ALTB 0x3000
#define ALTH 0x2300
#define ALTP 0x1900
#define PGUP 0x4900
#define PGDN 0x5100
#define ALTF10 0x7100

struct CONTROL ctl;


struct baud_str {
	char *str;
	unsigned rate;
	};

struct baud_str btypes[] = {
	{	 "300",  BAUD_300   },
	{	"1200",  BAUD_1200  },
	{	"2400",  BAUD_2400  },
	{	"4800",  BAUD_4800  },
	{	"9600",  BAUD_9600  },
	{	"19200", BAUD_19200 },
	{	  NULL,  0 }
};

int cur_baud,locate_x,locate_y,port_ptr;

main (argc, argv)
int argc;
char *argv[];
{
	int k;
	char c;
	int done;
	long t1;
	char prot;
	int baud;
	int err;
	char junk[100];
	extern long timerset();
	extern char *receive_file();

	signal (SIGINT, SIG_IGN);

	ctl.handshake_mask = USE_XON;
	ctl.carrier_mask = 0x80;

	baud = 2;

	while (--argc)
		{
		++argv;
		if (argv[0][0] == '-')
			{
			switch (argv[0][1])
				{
				case 'p':
				case 'P':
					port_ptr = atoi(argv[1])-1;
					++argv;
					--argc;
					break;

				case 'b':
				case 'B':
					for (k = 0; btypes[k].str != NULL; k++)
						{
						if (strcmp (btypes[k].str, argv[1]) == 0)
							{
							baud = k;
							++argv;
							--argc;
							break;
							}
						}
					break;

				default:
					scr_printf ("I don't know argument '");
					scr_printf (argv[0]);
					scr_printf ("'\r\n");
					break;
				}
			}
		else
			{
			scr_printf ("I don't understand '");
			scr_printf (argv[0]);
			scr_printf ("'\r\n");
			}
		}
	cur_baud = atoi(btypes[baud].str);
	scr_printf ("\033[H\033[J");
	scr_printf ("BinkleyTerm Version 1.00\r\n");
	scr_printf ("A Companion Package for communicating with the Opus CBCS\r\n");
	scr_printf ("Setting COM");
	WRITE_ANSI (port_ptr + '1');
	scr_printf (": to initial speed of ");
	scr_printf (btypes[baud].str);
	scr_printf (" baud. Press Alt-F10 for HELP.\r\n\r\n");

	if (Cominit(port_ptr) != 0x1954)
		{
		scr_printf ("I'm sorry, there doesn't appear to be a FOSSIL driver loaded.\r\n");
		scr_printf ("BinkleyTerm requires a FOSSIL driver. Please take care of this before\r\n");
		scr_printf ("attempting to run BinkleyTerm again.\r\n");
		exit (1);
		}

	MDM_ENABLE(btypes[baud].rate);
	DTR_ON();
	XON_ENABLE();
	done = 0;
	while (!done)
		{
		if (CHAR_AVAIL())
			{
			c = MODEM_IN();
			WRITE_ANSI(c);
			}
		time();
		if (KEYPRESS())
			{
			k = FOSSIL_CHAR();
			switch (k)
				{
				case ALTX:
					done = 1;
					break;
				case ALTH:
					t1 = timerset (300);
					while (CARRIER)
						if (timeup(t1))
							{
							scr_printf ("\r\nUnable to force carrier drop by dropping DTR!\r\n");
							break;
							}
						else
							{
							DTR_OFF();
							}
					DTR_ON();
					break;
				case ALTB:
					++baud;
					if (btypes[baud].str == NULL)
						baud = 0;
					MDM_ENABLE(btypes[baud].rate);
					cur_baud = atoi(btypes[baud].str);
					scr_printf ("\r\nBinkleyTerm now communicating at ");
					scr_printf (btypes[baud].str);
					scr_printf (" baud.\r\n");
					break;
				case ALTP:
					port_ptr = !port_ptr;
					MDM_DISABLE();
					Cominit(port_ptr);
					MDM_ENABLE(btypes[baud].rate);
					DTR_ON();
					scr_printf ("\r\nBinkleyTerm now using COM");
					WRITE_ANSI (port_ptr + '1');
					scr_printf (":\r\n");
					XON_ENABLE();
					break;
				case PGUP:
					XON_DISABLE();
					scr_printf("BinkleyTerm is ready to SEND a file...\r\n");
					scr_printf("Which Protocol do you want BinkleyTerm to use?\r\n");
					scr_printf("Z)modem     Y)modem     S)EAlink     X)modem\r\n");
                                        scr_printf("OK....Choose! ");
					fgets (junk, 100, stdin);
					prot = toupper (junk[0]);
						if ((prot != 'X') && (prot != 'Y')
						&& (prot != 'S') &&  (prot != 'Z'))
						{
						scr_printf ("Sorry. I don't know that protocol, returning to terminal mode.\r\n");
						break;
						}
					scr_printf ("File to be sent? ");
					fgets (junk, 100, stdin);
					junk[strlen(junk) - 1] = '\0';
					err = 1;
					if (prot == 'Z')
						{
						Send_Zmodem(junk,NULL,0,0,0);
						Send_Zmodem(NULL,NULL,0,END_BATCH,0);
						}
					else	/* prot == 'X', 'Y', 'S' */
						{
						send_file (junk,prot);
						send_file (NULL, prot);
						}
					XON_ENABLE();
					break;
				case PGDN:
					XON_DISABLE();
					scr_printf("BinkleyTerm is ready to RECEIVE a file...\r\n");
					scr_printf("Which Protocol do you want BinkleyTerm to use?\r\n");
					scr_printf("Z)modem     Y)modem     S)EAlink     X)modem\r\n");
                                        scr_printf("OK....Choose! ");
					fgets (junk, 100, stdin);
					prot = toupper (junk[0]);
					junk[0] = '\0';
					if ((prot == 'X') || (prot == 'Y'))
						{
						scr_printf ("File to receive? ");
						fgets (junk, 100, stdin);
						junk[strlen(junk) - 1] = '\0';
						receive_file( "", junk, prot);
						}
					else
						{
						if ((prot != 'Z') && (prot != 'S'))
							{
							scr_printf ("Sorry. I don't know that protocol, returning to terminal mode.\r\n");
							break;
							}
						if (prot == 'Z')
							get_Zmodem("",NULL);
						else
							{
							err = 1;
							while (err)
								err = receive_file( "", junk, prot);
							}
						}
					XON_ENABLE();
					break;
				case ALTF10:
               usage();
					break;
				default:
					c = k & 0xff;
					if (c != 0)
						while (Com_Tx_NW (c) == 0)
							;
				}
			}
		}
	MDM_DISABLE();
	cprintf ("\r\n\r\nThanks for using BinkleyTerm.\r\nHope to see you back in the Meadow real soon!\r\n");
	}
usage()
{
scr_printf("\033[H\033[J");
scr_printf("BinkleyTerm is a companion package to the Opus Computer Based Conversation\r\n");
scr_printf("System. It provides most of the protocols that are native to the Opus CBCS\r\n");
scr_printf("using very similar source code. The protocols that are supported are\r\n");
scr_printf("Zmodem, Ymodem, SEAlink, and Xmodem.\r\n\r\n");
scr_printf("The terminal package uses the same type of FOSSIL driver as Opus to support\r\n");
scr_printf("its serial communications, screen and keyboarding functionality.\r\n\r\n");
scr_printf("For more details about SEAlink, contact System Enhancement Associates. For\r\n");
scr_printf("information about FOSSIL drivers, contact Vince Perriello at IFNA node\r\n");
scr_printf("141/491.\r\n\r\n\r\n"); 
scr_printf("BinkleyTerm is a perfect example of the KISS school of computer science. But\r\n");
scr_printf("there ARE a few things that you can tell BinkleyTerm to do:\r\n\r\n");
scr_printf("On the command line:\r\n\r\n");
scr_printf("     -b baud   Sets BT's baud rate. Legal values are 300, 1200, 2400,\r\n");
scr_printf("               4800, 9600 and 19200. The default value is 1200.\r\n\r\n");
scr_printf("     -p port   Designates the com port that BinkleyTerm should use.\r\n");
scr_printf("               Legal values are 1 or 2. The default value is 1.\r\n\r\n");
scr_printf("From the keyboard:\r\n\r\n");
scr_printf("     Alt-F10   Display this help screen.\r\n");
scr_printf("     Alt-X     Exit BinkleyTerm, return to DOS (DTR left high)\r\n");
scr_printf("     Alt-H     Hang up the phone by dropping DTR.\r\n");
scr_printf("     Alt-B     Set BT's baud rate to next higher value (19200 goes to 300)\r\n");
scr_printf("     Alt-P     Use the other com port now (COM1 <-> COM2)\r\n");
scr_printf("     PgUp      Send a file to Opus (UPLOAD)\r\n");
scr_printf("     PgDn      Receive a file from Opus (DOWNLOAD)\r\n\r\n");
}
